% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpSetPlot.R
\name{UpSetPlot}
\alias{UpSetPlot}
\title{UpSetPlot}
\usage{
UpSetPlot(
  WD_samples,
  Th_logFC,
  Th_Pvalue,
  collapseName,
  nintersects,
  st_significance,
  scale
)
}
\arguments{
\item{WD_samples}{Character. Directory containing DEG result CSV files.}

\item{Th_logFC}{Numeric. Absolute log2 fold-change threshold to include a gene.}

\item{Th_Pvalue}{Numeric. P-value threshold for significance (0 < Th_Pvalue <= 1).}

\item{collapseName}{Logical. If TRUE, strip method/model prefixes from file names when labeling sets.}

\item{nintersects}{Integer. Maximum number of intersections to display.}

\item{st_significance}{Character. Which p-value to use: "adjustPvalue" (FDR or FWER) or "PValue".}

\item{scale}{Numeric. Text scaling factor for plot labels and annotations.}
}
\value{
An UpSet plot.
}
\description{
Generate an UpSet plot of overlapping DEGs across multiple contrasts.
}
\details{
This function reads DEG CSV files from a directory, filters genes by log-FC and p-value
thresholds (adjusted or raw), optionally simplifies file names, and visualizes the
intersections of gene sets using an UpSet plot.
\enumerate{
\item Validates thresholds (Th_logFC >= 0, 0 < Th_Pvalue <= 1).
\item Lists all CSV files in WD_samples and reads each into a data frame.
\item Checks for duplicate IDs and standardizes to columns ID, logFC, and adjustPvalue or PValue.
\item Filters each set of results by |logFC| >= Th_logFC and p-value < Th_Pvalue.
\item Renames each gene-ID column to the (optionally collapsed) file name.
\item Converts the list of filtered ID sets to an UpSetR input and calls UpSetR::upset().
}
}
