% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidra_url.R
\name{parse_sidra_url}
\alias{parse_sidra_url}
\title{Parse a SIDRA API URL into ibger parameters}
\usage{
parse_sidra_url(url)
}
\arguments{
\item{url}{Character string. A SIDRA API URL, typically starting with
\verb{https://apisidra.ibge.gov.br/values/}.}
}
\value{
A list of class \code{sidra_query} with:
\itemize{
\item \code{aggregate}: list with \code{id} and \code{name}
\item \code{variables}: tibble with \code{id} and \code{name}
\item \code{periods}: character vector of period codes
\item \code{localities}: list of level/locality pairs
\item \code{classifications}: list of classification/category details
\item \code{ibger_call}: string with the equivalent \code{ibge_variables()} call
}
}
\description{
Converts a SIDRA API URL (from the SIDRA Query Builder or sidrar package)
into a human-readable breakdown of its parameters, enriched with names
from the aggregate metadata.
}
\examples{
\dontrun{
url <- "https://apisidra.ibge.gov.br/values/t/5434/n1/all/v/4090/p/last\%201/c888/47946,56623"
parse_sidra_url(url)
}

}
