% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_adjust_classes.R
\name{ifcb_adjust_classes}
\alias{ifcb_adjust_classes}
\title{Adjust Classifications in Manual Annotations}
\usage{
ifcb_adjust_classes(class2use_file, manual_folder, do_compression = TRUE)
}
\arguments{
\item{class2use_file}{A character string representing the full path to the class2use file
(should be a .mat file).}

\item{manual_folder}{A character string representing the path to the folder containing manual
annotation files. The function will look for files starting with 'D' in this folder.}

\item{do_compression}{A logical value indicating whether to apply compression to the output files.
Defaults to TRUE.}
}
\value{
None
}
\description{
This function adjusts the classifications in manual annotation files based on a class2use file.
It loads a specified class2use file and applies the adjustments to all relevant files in the
specified manual folder. Optionally, it can also perform compression on the output files.
This is the R equivalent function of \code{start_mc_adjust_classes_user_training} from the
\code{ifcb-analysis} repository (Sosik and Olson 2007).
}
\details{
Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

ifcb_adjust_classes("data/config/class2use.mat",
                    "data/manual/2014/")
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \code{\link{ifcb_create_class2use}} \url{https://github.com/hsosik/ifcb-analysis}
}
