% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{timeseries}
\alias{timeseries}
\title{Retrieve time series for a provider}
\usage{
timeseries(
  x,
  parameter,
  stations = NULL,
  start_date = NULL,
  end_date = NULL,
  mode = c("range", "complete"),
  ...
)
}
\arguments{
\item{x}{A \code{hydro_service} object created by \code{\link[=hydro_service]{hydro_service()}}.}

\item{parameter}{One of "water_discharge","water_level","water_temperature","water_velocity".}

\item{stations}{Optional character vector of station IDs.}

\item{start_date, end_date}{\code{YYYY-MM-DD} strings for \code{mode = "range"}.}

\item{mode}{Either \code{"range"} or \code{"complete"} (\code{1900-01-01} to today).}

\item{...}{Passed to provider-specific methods.}
}
\value{
A tibble with columns:
country, provider_id, provider_name, station_id, parameter,
timestamp, value, unit, quality_code, source_url.
}
\description{
Retrieve time series for a provider
}
\examples{
# Offline: construct a service object (no network)
x <- hydro_service("SE_SMHI")

\dontshow{if (interactive() && requireNamespace("curl", quietly = TRUE) && curl::has_internet() && identical(Sys.getenv("HYDRO_EXAMPLES"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Online (opt-in): one station for a short range
st <- head(stations(x)$station_id, 1)
ts <- timeseries(x, parameter = "water_discharge",
                 stations = st,
                 start_date = "2020-01-01", end_date = "2020-01-10")
head(ts)
\dontshow{\}) # examplesIf}
}
