% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.R
\name{gen.recursive}
\alias{gen.recursive}
\title{Build recursive structures in a way that guarantees termination.}
\usage{
gen.recursive(tails, heads)
}
\arguments{
\item{tails}{a list of generators which should not contain
recursive terms.}

\item{heads}{a list of generator which may contain recursive
terms.}
}
\description{
This will choose between the recursive and non-recursive terms,
while shrinking the size of the recursive calls.
}
\examples{
# Generating a tree with integer leaves
treeGen <-
  gen.recursive(
    # The non-recursive cases
    list(
      gen.int(100)
    )
  , # The recursive cases
    list(
      gen.list( treeGen )
    )
  )
}
