% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookup}
\alias{lookup}
\title{Find value corresponding to the input vector using a look-up table}
\usage{
lookup(x, link, lu, verbose = getOption("healthdb.verbose"))
}
\arguments{
\item{x}{A variable name in a data.frame; this function should be called inside dplyr::mutate().}

\item{link}{A formula in the form: name_of_x_in_lu ~ name_of_target_value. The left-hand-side can be omitted if x's name is also x in the look-up.}

\item{lu}{Look-up table in data.frame class.}

\item{verbose}{A logical for whether warn for missing values in the output.}
}
\value{
A vector of matched values.
}
\description{
Find value corresponding to the input vector using a look-up table
}
\examples{

df <- data.frame(drug_code = 1:10)
lu <- data.frame(drug_id = 1:20, drug_code = as.character(1:10), drug_name = sample(letters, 20))

df \%>\% dplyr::mutate(
  drug_nm = lookup(drug_code, drug_id ~ drug_name, lu),
  # this will work as lu also has drug_code column
  drug_nm = lookup(drug_code, ~drug_name, lu)
)
}
