% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aft_logml_leap.R
\name{aft.logml.leap}
\alias{aft.logml.leap}
\title{Log marginal likelihood of an accelerated failure time (AFT) model under latent exchangeability prior (LEAP)}
\usage{
aft.logml.leap(
  post.samples,
  bridge.args = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{post.samples}{output from \code{\link[=aft.leap]{aft.leap()}} giving posterior samples of an AFT model under the latent exchangeability
prior (LEAP), with an attribute called 'data' which includes the list of variables specified
in the data block of the Stan program.}

\item{bridge.args}{a \code{list} giving arguments (other than \code{samples}, \code{log_posterior}, \code{data}, \code{lb}, and \code{ub}) to
pass onto \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}}.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup}
in \code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method
in cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns a \code{list} with the following objects

\describe{
\item{model}{"aft_leap"}

\item{logml}{the estimated logarithm of the marginal likelihood}

\item{bs}{an object of class \code{bridge} or \code{bridge_list} containing the output from using
\code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}} to compute the logarithm of the normalizing constant of the
latent exchangeability prior (LEAP) using all data sets}

\item{bs.hist}{an object of class \code{bridge} or \code{bridge_list} containing the output from using
\code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler()}} to compute the logarithm of the normalizing constant of the
LEAP using historical data sets}

\item{min_ess_bulk}{the minimum estimated bulk effective sample size of the MCMC sampling}

\item{max_Rhat}{the maximum Rhat}
}
}
\description{
Uses Markov chain Monte Carlo (MCMC) and bridge sampling to estimate the logarithm of the marginal
likelihood of an AFT model under the latent exchangeability prior (LEAP).

The arguments related to MCMC sampling are utilized to draw samples from the LEAP. These
samples are then used to compute the logarithm of the normalizing constant of the LEAP using historical
data sets.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  if(requireNamespace("survival")){
    library(survival)
    data(E1684)
    data(E1690)
    ## take subset for speed purposes
    E1684 = E1684[1:100, ]
    E1690 = E1690[1:50, ]
    ## replace 0 failure times with 0.50 days
    E1684$failtime[E1684$failtime == 0] = 0.50/365.25
    E1690$failtime[E1690$failtime == 0] = 0.50/365.25
    E1684$cage = as.numeric(scale(E1684$age))
    E1690$cage = as.numeric(scale(E1690$age))
    data_list = list(currdata = E1690, histdata = E1684)
    d.leap = aft.leap(
      formula = survival::Surv(failtime, failcens) ~ treatment + sex + cage + node_bin,
      data.list = data_list,
      dist = "weibull",
      K= 2,
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
    aft.logml.leap(
      post.samples = d.leap,
      bridge.args = list(silent = TRUE),
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
  }
}
}
\references{
Alt, E. M., Chang, X., Jiang, X., Liu, Q., Mo, M., Xia, H. M., and Ibrahim, J. G. (2024). LEAP: The latent exchangeability prior for borrowing information from historical data. Biometrics, 80(3).

Gronau, Q. F., Singmann, H., and Wagenmakers, E.-J. (2020). bridgesampling: An r package for estimating normalizing constants. Journal of Statistical Software, 92(10).
}
