% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gutenberg_strip.R
\name{gutenberg_strip}
\alias{gutenberg_strip}
\title{Strip header and footer content from a Project Gutenberg book}
\usage{
gutenberg_strip(text)
}
\arguments{
\item{text}{A character vector where each element is a line of a book.}
}
\value{
A character vector with Project Gutenberg headers and footers removed.
}
\description{
Strip header and footer content from a Project Gutenberg book. This
is based on formatting heuristics (regular expression guesses), so it
may not be perfect.
}
\details{
This function identifies the  Project Gutenberg "start" and "end" markers.
It also attempts to strip out initial metadata paragraphs (such as
"Produced by...", "Transcribed from...", etc.).

Note that this will \strong{not} strip:
\itemize{
\item Tables of contents
\item Prologues or introductions
\item Other author-written text that appears at the start of a book
}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(dplyr)

# Download a book without stripping to see the headers
book <- gutenberg_works(title == "Pride and Prejudice") |>
  gutenberg_download(strip = FALSE)

# Look at the raw header and footer
head(book$text, 20)
tail(book$text, 20)

# Manually strip the text
text_stripped <- gutenberg_strip(book$text)

# Check the cleaned results
head(text_stripped, 10)
tail(text_stripped, 10)
\dontshow{\}) # examplesIf}
}
