% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head.R
\name{head.gtsummary}
\alias{head.gtsummary}
\alias{tail.gtsummary}
\title{Display the first or last rows}
\usage{
\method{head}{gtsummary}(x, n = 6L, ...)

\method{tail}{gtsummary}(x, n = 6L, ...)
}
\arguments{
\item{x}{A \code{gtsummary} object.}

\item{n}{Number of rows to return. Default is \code{6L} as default in \code{\link[utils:head]{utils::head()}} and
\code{\link[utils:head]{utils::tail()}}.}

\item{...}{Additional arguments passed to \code{\link[utils:head]{utils::head()}} or \code{\link[utils:head]{utils::tail()}}.}
}
\value{
A \code{gtsummary} object with only the first or last \code{n} rows in \code{table_body}.
}
\description{
These functions allow you to view the first (\code{head()}) or last (\code{tail()}) \code{n}
rows of a gtsummary table.
}
\examples{
# head() example
trial |>
  tbl_summary(by = trt) |>
  head(n = 2L)

# tail() example
trial |>
  tbl_summary(by = trt) |>
  tail(n = 2L)

}
\keyword{internal}
