% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Wald.and.Boundary.R
\name{TwoSample.Wald.and.Boundary}
\alias{TwoSample.Wald.and.Boundary}
\title{Function to calculate the Wald statistics and group sequential boundaries for two-sample monitoring.}
\usage{
TwoSample.Wald.and.Boundary(
  Q.cov.est,
  spend,
  calendars,
  alpha,
  planned.n,
  Iunit
)
}
\arguments{
\item{Q.cov.est}{A list containing stage-wise estimates and covariances, either returned by \code{TwoSample.Estimator.LR.sequential()}
or \code{TwoSample.Estimator.GT.sequential()}.}

\item{spend}{A function specifying the cumulative Type I error spending function \eqn{\alpha(t)} evaluated at information fraction
\code{t}. For example, \code{OBF}.}

\item{calendars}{Numeric vector of analysis calendar times (in years), defining the planned monitoring schedule and number of analysis.}

\item{alpha}{Overall two-sided Type I error.}

\item{planned.n}{Planned total sample size at the final analysis.}

\item{Iunit}{Information per subject (or per unit of sample size) used to scale the information fractions.}
}
\value{
A list with components:
\itemize{
\item \code{Qs}: Stage-wise test statistics.
\item \code{vars}: Stage-wise variance estimates for \code{Qs}.
\item \code{raw.information}: Information fractions prior to any adjustments for early completion or skipped analysis.
\item \code{Wald}: Stage-wise Wald statistics \code{Qs/sqrt(vars)}.
\item \code{consistent.bdry}: Two-sided rejection boundaries computed using the consistent correlation matrix.
\item \code{canonical.bdry}: Two-sided rejection boundaries computed using the canonical correlation matrix.
\item \code{consistent.reject}: Indicator vector for boundary crossing under the consistent approach (only the the first crossing is retained).
\item \code{canonical.reject}: Indicator vector for boundary crossing under the canonical approach (only the the first crossing is retained).
\item \code{nu}: Final information fractions used for boundary construction.
\item \code{pi}: Incremental Type I error allocated to each analysis.
\item \code{total.ns}: Total accrued sample size at each analysis.
}
}
\description{
Computes stage-wise Wald statistics from estimated two-sample statistics and their variances, determines information
fractions, allocates Type I error using a user specified spending function, and constructs corresponding two-sided
rejection boundaries. The function supports both a consistent correlation approach (supplied in \code{Q.cov.est}) and
a canonical correlation approach based on information fractions.
}
