% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutze_test.R
\name{mutze_test}
\alias{mutze_test}
\alias{print.mutze_test}
\title{Wald test for treatment effect using negative binomial model (Mutze et al.)}
\usage{
mutze_test(
  data,
  method = c("nb", "poisson"),
  conf_level = 0.95,
  sided = 1,
  poisson_threshold = 1000
)

\method{print}{mutze_test}(x, ...)
}
\arguments{
\item{data}{A data frame with at least the columns \code{treatment}, \code{events}, and
\code{tte} (follow-up time). Typically output from \code{\link[=cut_data_by_date]{cut_data_by_date()}}.}

\item{method}{Type of model to fit: "nb" (default) uses a negative binomial
GLM via \code{\link[MASS:glm.nb]{MASS::glm.nb()}}, "poisson" fits a Poisson GLM.}

\item{conf_level}{Confidence level for the rate ratio interval. Default 0.95.}

\item{sided}{Number of sides for the test: 1 (default) or 2.}

\item{poisson_threshold}{When \code{method = "nb"}, the model falls back to
Poisson regression if theta (the NB shape parameter) is outside the range
\verb{[1/poisson_threshold, poisson_threshold]}. Very large theta indicates
near-Poisson data, while very small theta indicates extreme overdispersion
with unstable estimates. Default is 1000.}

\item{x}{An object of class \code{mutze_test}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{mutze_test} containing the fitted model summary with elements:
\itemize{
\item \code{method}: A string indicating the test method used.
\item \code{estimate}: log rate ratio (experimental vs control).
\item \code{se}: standard error for the log rate ratio.
\item \code{z}: Wald statistic.
\item \code{p_value}: one-sided or two-sided p-value.
\item \code{rate_ratio}: estimated rate ratio and its confidence interval.
\item \code{dispersion}: estimated dispersion (theta) when \code{method = "nb"}.
\item \code{group_summary}: observed subjects/events/exposure per treatment.
}

Invisibly returns the input object.
}
\description{
Fits a negative binomial (or Poisson) log-rate model to the aggregated
subject-level data produced by \code{\link[=cut_data_by_date]{cut_data_by_date()}}. The method matches the
Wald test described by Mutze et al. (2019) for comparing treatment arms with
recurrent event outcomes.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(mutze_test)}: Print method for \code{mutze_test} objects.

}}
\examples{
enroll_rate <- data.frame(rate = 20 / (5 / 12), duration = 5 / 12)
fail_rate <- data.frame(treatment = c("Control", "Experimental"), rate = c(0.5, 0.3))
dropout_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.1, 0.05), duration = c(100, 100)
)
sim <- nb_sim(enroll_rate, fail_rate, dropout_rate, max_followup = 2, n = 40)
cut <- cut_data_by_date(sim, cut_date = 1.5)
mutze_test(cut)
}
