% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-methods.R
\name{add_sizer}
\alias{add_sizer}
\alias{add_sizer.derivatives}
\alias{add_sizer.smooth_estimates}
\title{Add indicators of significant change after SiZeR}
\usage{
add_sizer(object, type = c("change", "sizer"), ...)

\method{add_sizer}{derivatives}(object, type = c("change", "sizer"), ...)

\method{add_sizer}{smooth_estimates}(object, type = c("change", "sizer"), derivatives = NULL, ...)
}
\arguments{
\item{object}{an R object. Currently supported methods are for classes
\code{"derivatives"}.}

\item{type}{character; \code{"change"} adds a single variable to \code{object}
indicating where the credible interval on the derivative excludes 0.
\code{"sizer"} adds two variables indicating whether the derivative is positive
or negative.}

\item{...}{arguments passed to other methods}

\item{derivatives}{an object of class \code{"derivatives"}, resulting from a call
to \code{\link[=derivatives]{derivatives()}}.}
}
\description{
Add indicators of significant change after SiZeR
}
\examples{
load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
df <- data_sim("eg1", n = 400, dist = "normal", scale = 2, seed = 42)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

## first derivatives of all smooths using central finite differences
d <- derivatives(m, type = "central") |>
  add_sizer()

# default adds a .change column
names(d)
}
