% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate Data for gradLasso}
\usage{
simulate_data(
  n = 1000,
  p = 20,
  family = "gaussian",
  rho = 0.2,
  k = 5,
  k_mu = 5,
  k_pi = 5,
  theta = 1,
  intercept_mu = 0,
  intercept_pi = -1,
  snr = 3
)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of predictors.}

\item{family}{Model family: "gaussian", "binomial", "negbin", or "zinb".}

\item{rho}{Correlation coefficient between predictors (Toeplitz structure).}

\item{k}{Number of non-zero coefficients (sparsity) for single-part models.}

\item{k_mu}{Number of non-zero coefficients for Count part (ZINB only).}

\item{k_pi}{Number of non-zero coefficients for Zero part (ZINB only).}

\item{theta}{Dispersion parameter for NegBin and ZINB.}

\item{intercept_mu}{Intercept for main model (or count part).}

\item{intercept_pi}{Intercept for zero-inflation part.}

\item{snr}{Signal-to-noise ratio (Gaussian only).}
}
\value{
A list containing the following components:
\item{X}{A matrix of predictor variables with induced correlation.}
\item{y}{A vector of the simulated response variable.}
\item{family}{The family string used for simulation.}
\item{truth}{A list containing the true parameters used to generate the data (e.g., \code{beta}, \code{theta}, \code{sigma}).}
}
\description{
Generates synthetic data for Gaussian, Binomial, Negative Binomial, or ZINB models
with correlated predictors.
}
