% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth_gargle.R
\name{gar_auth_configure}
\alias{gar_auth_configure}
\alias{gar_api_key}
\alias{gar_oauth_app}
\title{Edit and view auth configuration}
\usage{
gar_auth_configure(app, path, api_key)

gar_api_key()

gar_oauth_app()
}
\arguments{
\item{app}{A Google OAuth client, presumably constructed via \link[gargle]{gargle_oauth_client_from_json}. Note, however, that it is preferred to specify the client with JSON, using the `path` argument.}

\item{path}{JSON downloaded from \href{https://console.cloud.google.com}{Google Cloud Console}, containing a client id and secret, in one of the forms supported for the \code{txt} argument of \code{\link[jsonlite]{fromJSON}} (typically, a file path or JSON string).}

\item{api_key}{API key.}
}
\value{
* `gar_auth_configure()`: An object of R6 class
    [gargle::AuthState], invisibly.
  * `gar_oauth_client()`: the current user-configured OAuth client.
  * `gar_api_key()`: the current user-configured API key.
}
\description{
These functions give more control over and visibility into the auth
configuration than [gar_auth()] does. `gar_auth_configure()`
lets the user specify their own:
  * OAuth client, which is used when obtaining a user token.
  * API key. If googleAuthR is de-authorized via [gar_deauth()], all
    requests are sent with an API key in lieu of a token.

See the `vignette("get-api-credentials", package = "gargle")`
for more.
If the user does not configure these settings, internal defaults
are used.

`gar_oauth_client()` and `gar_api_key()` retrieve the
currently configured OAuth client and API key, respectively.
}
\examples{
# see and store the current user-configured OAuth app (probaby `NULL`)
(original_app <- gar_oauth_app())

# see and store the current user-configured API key (probaby `NULL`)
(original_api_key <- gar_api_key())

if (require(httr)) {
  # bring your own app via client id (aka key) and secret
  google_app <- httr::oauth_app(
    "my-awesome-google-api-wrapping-package",
    key = "123456789.apps.googleusercontent.com",
    secret = "abcdefghijklmnopqrstuvwxyz"
  )
  google_key <- "the-key-I-got-for-a-google-API"
  gar_auth_configure(app = google_app, api_key = google_key)

  # confirm the changes
  gar_oauth_app()
  gar_api_key()
}

\dontrun{
## bring your own app via JSON downloaded from Google Developers Console
gar_auth_configure(
  path = "/path/to/the/JSON/you/downloaded/from/google/dev/console.json"
)
}

# restore original auth config
gar_auth_configure(app = original_app, api_key = original_api_key)
}
\seealso{
Other auth functions: 
\code{\link{gar_deauth}()}
}
\concept{auth functions}
