% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/nrmSelection.R
\name{nrmChoose}
\alias{nrmChoose}
\alias{nrm_choose}
\title{Selects the best set of predictors among the given sets by means of AIC.}
\usage{
nrmChoose(
  adj,
  w.list,
  xi = NULL,
  directed,
  selfloops,
  pval = 0.05,
  init = NULL,
  ncores = NULL
)

nrm_choose(
  adj,
  w.list,
  xi = NULL,
  directed,
  selfloops,
  pval = 0.05,
  init = NULL,
  ncores = NULL
)
}
\arguments{
\item{adj}{adjacency matrix}

\item{w.list}{nrmPredictor object. Nested list of predictors to be selected.}

\item{xi}{Xi matrix (optional). defaults to scm Xi matrix.}

\item{directed}{logical. Is the network directed?}

\item{selfloops}{logical. Does the network contain selfloops?}

\item{pval}{numeric. the significance at which computing confidence
intervals. defaults to 0.05}

\item{init}{initial values for the MLE numerical maximisation. (See
\code{nrm}.)}

\item{ncores}{Number of cores for parallelisation of selection process.
(optional) Defaults to number of available cores - 1.}
}
\value{
list containing the best model according to AIC and id of the
  corresponding predictors in the list
}
\description{
Computes all the models defined by a list of groups of predictors Returns the
best model according to AIC and id of the corresponding predictors in the
list The different models are computed in parallel
}
