% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqfplot.R
\name{ggseqfplot}
\alias{ggseqfplot}
\title{Sequence Frequency Plot}
\usage{
ggseqfplot(
  seqdata,
  group = NULL,
  ranks = 1:10,
  weighted = TRUE,
  border = FALSE,
  proportional = TRUE,
  ylabs = "total",
  no.coverage = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{group}{A vector of the same length as the sequence data indicating group membership. When not NULL, a distinct plot is generated for each level of group.}

\item{ranks}{specifies which of the most frequent sequences should be plotted;
default is the first ten (\code{1:10}); if set to 0 all sequences are displayed}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{border}{if \code{TRUE} bars are plotted with black outline; default is \code{FALSE} (also accepts \code{NULL})}

\item{proportional}{if \code{TRUE} (default), the sequence heights are
displayed proportional to their frequencies}

\item{ylabs}{defines appearance of y-axis labels; default (\code{"total"})
only labels min and max (i.e. cumulative relative frequency); if \code{"share"} labels indicate
relative frequency of each displayed sequence (note: overlapping labels are removed)}

\item{no.coverage}{specifies if information on total coverage is shown as
caption or as part of the group/facet label if \code{ylabs == "share"}
(default is \code{TRUE})}

\item{facet_ncol}{Number of columns in faceted (i.e. grouped) plot}

\item{facet_nrow}{Number of rows in faceted (i.e. grouped) plot}
}
\value{
A sequence frequency plot created by using \code{\link[ggplot2]{ggplot2}}.
If stored as object the resulting list object (of class gg and ggplot) also
contains the data used for rendering the plot.
}
\description{
Function for rendering sequence index plot of the most frequent sequences of
a state sequence object using \code{\link[ggplot2]{ggplot2}} \insertCite{wickham2016}{ggseqplot}
instead of base R's \code{\link[base]{plot}} function that is used by
\code{\link[TraMineR:seqfplot]{TraMineR::seqplot}} /
\code{\link[TraMineR:plot.stslist.freq]{TraMineR::plot.stslist.freq}} \insertCite{gabadinho2011}{ggseqplot}.
}
\details{
The subset of displayed sequences is obtained by an internal call of
\code{\link[TraMineR:seqtab]{TraMineR::seqtab}}. The extracted sequences are plotted
by a call of \code{\link[ggseqplot:ggseqiplot]{ggseqiplot}} which uses
\code{\link[ggplot2:geom_rect]{ggplot2::geom_rect}} to render the sequences. The data
and specifications used for rendering the plot can be obtained by storing the
plot as an object. The appearance of the plot can be adjusted just like with
every other ggplot (e.g., by changing the theme or the scale using \code{+} and
the respective functions).

Experienced ggplot2 users might notice the customized labeling of the
y-axes in the faceted plots (i.e. plots with specified \code{group} argument). This has
been achieved by utilizing the very helpful \code{\link[ggh4x]{ggh4x}} library.
}
\examples{
# Use example data from TraMineR: actcal data set
data(actcal)

# We use only a sample of 300 cases
set.seed(1)
actcal <- actcal[sample(nrow(actcal), 300), ]
actcal.lab <- c("> 37 hours", "19-36 hours", "1-18 hours", "no work")
actcal.seq <- seqdef(actcal, 13:24, labels = actcal.lab)

# sequence frequency plot
# with TraMineR::seqplot
seqfplot(actcal.seq)
# with ggseqplot
ggseqfplot(actcal.seq)
# with ggseqplot applying additional arguments and some layout changes
ggseqfplot(actcal.seq,
           group = actcal$sex,
           ranks = 1:5,
           ylabs = "share") +
  scale_x_discrete(breaks = 1:12,
                   labels = month.abb,
                   expand = expansion(add = c(0.2, 0)))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[ggseqplot:ggseqiplot]{ggseqiplot}}
}
\author{
Marcel Raab
}
