% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cowplot_helpers.R
\name{shared_legend}
\alias{shared_legend}
\title{Combine Plots with a Shared Legend}
\usage{
shared_legend(
  ...,
  ncol = NULL,
  nrow = NULL,
  position = c("right", "left", "bottom", "top"),
  legend_from = 1,
  rel_legend_size = 0.2
)
}
\arguments{
\item{...}{ggplot objects to combine.}

\item{ncol}{Number of columns in the plot grid.}

\item{nrow}{Number of rows in the plot grid. If NULL (default), computed
from ncol and number of plots.}

\item{position}{Where to place the shared legend. One of \code{"right"}
(default), \code{"left"}, \code{"bottom"}, or \code{"top"}.}

\item{legend_from}{Which plot to extract the legend from. Default is 1
(first plot). Can be an integer index or a ggplot object.}

\item{rel_legend_size}{Relative size of the legend compared to the plot
area. Default is 0.2 (20 percent).}
}
\value{
A gtable that can be drawn with \code{grid::grid.draw()} or used
with \code{cowplot::ggdraw()}.
}
\description{
Combines multiple ggplot objects into a grid layout with a single shared
legend. Works with base ggplot and cowplot workflows (no patchwork required).
}
\details{
This function provides a simple way to create multi-panel plots with a
shared legend without requiring patchwork. It:
\enumerate{
\item Removes legends from all plots
\item Extracts the legend from the specified plot
\item Arranges plots in a grid
\item Attaches the legend to the specified position
}

For more complex layouts or patchwork users, see \code{\link{collect_legends}}.
}
\examples{
library(ggplot2)

p1 <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() + labs(title = "Plot 1", color = "Cylinders")
p2 <- ggplot(mtcars, aes(mpg, hp, color = factor(cyl))) +
  geom_point() + labs(title = "Plot 2", color = "Cylinders")
p3 <- ggplot(mtcars, aes(mpg, disp, color = factor(cyl))) +
  geom_point() + labs(title = "Plot 3", color = "Cylinders")

# Side-by-side with shared legend on right
gt <- shared_legend(p1, p2, ncol = 2, position = "right")
grid::grid.newpage()
grid::grid.draw(gt)

# 2x2 grid with legend at bottom
gt <- shared_legend(p1, p2, p3, p1, ncol = 2, nrow = 2, position = "bottom")
grid::grid.newpage()
grid::grid.draw(gt)

# Stacked with legend on left
gt <- shared_legend(p1, p2, p3, ncol = 1, position = "left")
grid::grid.newpage()
grid::grid.draw(gt)

}
\seealso{
\code{\link{get_legend}}, \code{\link{collect_legends}}
}
