% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggamma-package.R
\docType{package}
\name{ggamma-package}
\alias{ggamma}
\alias{ggamma-package}
\title{Generalized Gamma Probability Distribution}
\description{
Density, distribution function, quantile function and random
generation for the Generalized Gamma lifetime distributions.
}
\details{
This package follows naming convention that is consistent with base R,
where density (or probability mass) functions, distribution functions,
quantile functions and random generation functions names are followed by
\code{d}, \code{p}, \code{q}, and \code{r} prefixes.

Behaviour of the functions is consistent with base R, where for
not valid parameters values \code{NaN}'s are returned, while
for values beyond function support \code{0}'s are returned
(e.g. for non-integers in discrete distributions, or for
negative values in functions with non-negative support).

C++ was not used, as the R code proved itself most efficient.
See the package website page for more details.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/matheushjs/ggamma}
  \item Report bugs at \url{https://github.com/matheushjs/ggamma/issues}
}

}
\author{
\strong{Maintainer}: Matheus H. J. Saldanha \email{mhjsaldanha@gmail.com}

Authors:
\itemize{
  \item Adriano K. Suzuki \email{suzuki@icmc.usp.br}
}

}
