% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gerda_census.R
\name{add_gerda_census}
\alias{add_gerda_census}
\title{Add Census 2022 Data to GERDA Election Data}
\usage{
add_gerda_census(election_data)
}
\arguments{
\item{election_data}{A data frame containing GERDA election data. Must contain
either an \code{ags} column (municipality level) or a \code{county_code}
column (county level).}
}
\value{
The input data frame with additional census columns appended. The
number of rows remains unchanged (left join).
}
\description{
Convenience function to merge Zensus 2022 municipality-level data with
GERDA election data. The census provides a cross-sectional snapshot (2022),
so the same values are attached to all election years.

The function works with both municipality-level and county-level election data:
\itemize{
\item \strong{Municipality-level data}: Direct merge using 8-digit AGS codes
\item \strong{County-level data}: Census data is aggregated to the county level
(population-weighted means for shares, sums for counts) before merging
}
}
\details{
\subsection{Required Columns}{

The input data must contain one of:
\itemize{
\item \code{ags}: 8-digit municipal code for municipality-level data
\item \code{county_code}: 5-digit county code for county-level data
}
}

\subsection{Merge Behavior}{

Since the census is a 2022 cross-section, census values are the same for all
election years. The merge is on geography only (no year join).

For county-level data, municipality-level census data is first aggregated:
\itemize{
\item Share variables: Population-weighted means
\item Count variables (population_census22, total_dwellings_census22): Sums
\item Other variables (avg_household_size_census22, avg_rent_per_m2_census22): Population-weighted means
}
}
}
\examples{
\dontrun{
library(gerda)

# Municipality-level merge
muni_data <- load_gerda_web("federal_muni_harm_21") |>
  add_gerda_census()

# County-level merge (aggregated from municipalities)
county_data <- load_gerda_web("federal_cty_harm") |>
  add_gerda_census()
}

}
\seealso{
\itemize{
\item \code{\link{gerda_census}} for direct access to the census data
\item \code{\link{gerda_census_codebook}} for variable descriptions
}
}
