% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdi.r
\name{expandConvexHull}
\alias{expandConvexHull}
\title{Estimate soft tissue expansion factors following Macaulay et al. 2023}
\usage{
expandConvexHull(
  volume = NULL,
  method = "isometry",
  taxon = "Croc_Lizard",
  segment = "Trunk"
)
}
\arguments{
\item{volume}{Numeric value containing volume of the convex hull (in liters). Defaults to NULL, in which case an isometric expansion factor is always returned. Setting for this parameter is ignored if method=="isometry"}

\item{method}{Method to use for deriving soft tissue expansion factor. Possible optios are "isometry" (default), "OLS" or "PGLS".}

\item{taxon}{Taxon whose specific regressions or expansion factors to use, can be "Croc_Lizard" for the expansions based on Crocodilians and Squamates, "Bird" for expansions based on birds of "All" for the pooled (allometric) or averaged (isometric) expansions.}

\item{segment}{Body segment for which expansion factor should be calculated. Possible options are: "Head", "Neck", "Trunk", "Tail", "Humerus", "Forearm", "Hand", "Thigh", "Shank", "MT" or "Pes"}
}
\value{
A single numeric, containing the calculated expansion factor
}
\description{
Estimate soft tissue expansion factors following Macaulay et al. 2023
}
\details{
This function returns a soft tissue expansion factor, calculated as the quotient of the skin volume and minimum convex hull volume of the selected body segment. This is based on expansion factors and regressions for birds and non-avianreptiles from Macaulay et al. 2023 (<10.1038/s41467-023-37317-y>). OLS and PGLS estimate the body volume allometrically following supplements 3, 4 and 5 of Macaulay et al., while isometry returns an isometric expansion factor following supplement 6. The body segment "Tail" should not be used in conjunction with the taxon "Bird", due to the absence of tails in this group – if this occurs nonethemess, an expansion factor of 1 is returned.
}
\examples{
expandConvexHull(50,"isometry",taxon="Croc_Lizard",segment="Trunk")
}
