% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{formula.galamm}
\alias{formula.galamm}
\title{Extract formula from fitted galamm object}
\usage{
\method{formula}{galamm}(x, ...)
}
\arguments{
\item{x}{Object of class \code{galamm} returned from \code{\link{galamm}}.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
The formula used to fit the model.
}
\description{
Extract formula from fitted galamm object
}
\examples{
# Mixed response model ------------------------------------------------------

# The mresp dataset contains a mix of binomial and Gaussian responses.

# We need to estimate a factor loading which scales the two response types.
loading_matrix <- matrix(c(1, NA), ncol = 1)

# Define mapping to families.
families <- gfam(list(gaussian, binomial))


# Fit the model
mod <- galamm(
  formula = y ~ x + (0 + level | id),
  data = mresp,
  family = families,
  factor = "level",
  load_var = "itemgroup",
  lambda = loading_matrix
)

# Formula
formula(mod)

}
\seealso{
Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{appraise.galamm}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{derivatives.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{model.frame.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
