% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarto_generate.R
\name{quarto_generate_all}
\alias{quarto_generate_all}
\title{Generate Quarto Configurations for Project}
\usage{
quarto_generate_all(
  project_path,
  project_type,
  render_dirs = NULL,
  quarto_settings = NULL,
  directories = NULL,
  root_output_dir = NULL
)
}
\arguments{
\item{project_path}{Character. Path to project root}

\item{project_type}{Character. One of "project", "project_sensitive", "course", "presentation"}

\item{render_dirs}{Named list. Render directories with their paths}

\item{quarto_settings}{List. Quarto settings (html and revealjs configs)}

\item{directories}{Named list. Source directories keyed the same as render_dirs}

\item{root_output_dir}{Optional output directory to set on the root _quarto.yml}
}
\value{
List with success status and paths of generated files
}
\description{
Main entry point for generating all \verb{_quarto.yml} files in a project.
Generates root config and directory-specific configs based on project type.
}
