% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_notebook.R
\name{make_notebook}
\alias{make_notebook}
\title{Create a Notebook or Script from Stub Template}
\usage{
make_notebook(
  name,
  type = NULL,
  dir = NULL,
  stub = "default",
  overwrite = FALSE,
  subdir = NULL
)
}
\arguments{
\item{name}{Character. The file name. Extension determines type:
\itemize{
\item .qmd: Quarto notebook (default if no extension)
\item .Rmd: RMarkdown notebook
\item .R: R script
Examples: \code{1-init}, \code{1-init.qmd}, \code{analysis.Rmd}, \code{script.R}
}}

\item{type}{Character. File type: "quarto", "rmarkdown", or "script".
Auto-detected from extension if provided. If NULL (default):
\enumerate{
\item Checks config \code{default_notebook_format} (or legacy \code{options$default_notebook_format})
\item Falls back to "quarto" (Framework is Quarto-first)
}}

\item{dir}{Character. Directory to create the file in. Uses your project's
configured \code{directories$notebooks} setting. Default: "notebooks/".}

\item{stub}{Character. Name of the stub template to use. Defaults to
"default". User can create custom stubs in \verb{stubs/notebook-\{stub\}.qmd},
\verb{stubs/notebook-\{stub\}.Rmd}, or \verb{stubs/script-\{stub\}.R}.}

\item{overwrite}{Logical. Whether to overwrite existing file. Default FALSE.}

\item{subdir}{Optional subdirectory under \code{dir} (e.g., "analyses/exploratory").}
}
\value{
Invisible path to created notebook
}
\description{
Creates a new Quarto (.qmd), RMarkdown (.Rmd) notebook, or R script (.R)
from stub templates. Searches for user-provided stubs first (in \verb{stubs/}
directory), then falls back to framework defaults.
}
\details{
\strong{Convenient aliases}: Use \code{\link[=make_qmd]{make_qmd()}} or \code{\link[=make_rmd]{make_rmd()}} for explicit
Quarto or RMarkdown notebook creation. Use \code{\link[=make_revealjs]{make_revealjs()}} or
\code{\link[=make_presentation]{make_presentation()}} for reveal.js presentations.
\subsection{Default Output}{

Notebooks are created in the \verb{notebooks/} directory by default:

\if{html}{\out{<div class="sourceCode">}}\preformatted{notebooks/
  1-data-cleaning.qmd
  2-analysis.qmd
  3-visualization.qmd
}\if{html}{\out{</div>}}
}

\subsection{Extension Normalization}{
\itemize{
\item If name includes \code{.qmd} or \code{.Rmd}, type is auto-detected
\item If no extension provided, \code{.qmd} is used (Quarto-first)
\item Use \code{type = "rmarkdown"} to default to \code{.Rmd}
}
}

\subsection{Stub Template Resolution}{

The function searches for stub templates in this order:
\enumerate{
\item User stubs: \verb{stubs/notebook-\{stub\}.qmd} or \verb{stubs/notebook-\{stub\}.Rmd}
\item Framework stubs: \verb{inst/stubs/notebook-\{stub\}.qmd} or \verb{inst/stubs/notebook-\{stub\}.Rmd}
}

Custom stub templates can use placeholders:
\itemize{
\item \code{{filename}} - The notebook filename without extension
\item \code{{date}} - Current date (YYYY-MM-DD)
}
}
}
\examples{
\donttest{
if (FALSE) {
# Create notebooks/1-init.qmd (defaults to Quarto)
make_notebook("1-init")

# Create notebooks/analysis.Rmd (RMarkdown, extension-based)
make_notebook("analysis.Rmd")

# Explicit type parameter
make_notebook("report", type = "rmarkdown")

# Use custom stub template
make_notebook("report", stub = "minimal")

# Create in specific directory
make_notebook("explore", dir = "work")

# Convenient aliases (recommended for explicit types)
make_qmd("analysis")       # Always creates .qmd
make_rmd("report")         # Always creates .Rmd
make_revealjs("slides")    # Creates reveal.js presentation
make_presentation("deck")  # Alias for make_revealjs()
}
}

}
\seealso{
\code{\link[=make_qmd]{make_qmd()}}, \code{\link[=make_rmd]{make_rmd()}}, \code{\link[=make_revealjs]{make_revealjs()}}, \code{\link[=make_presentation]{make_presentation()}}
}
