% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_pool.R
\name{connection_pool}
\alias{connection_pool}
\title{Get or create a connection pool}
\usage{
connection_pool(
  name,
  min_size = 1,
  max_size = Inf,
  idle_timeout = 60,
  validation_interval = 60,
  recreate = FALSE
)
}
\arguments{
\item{name}{Character. Name of the connection in settings.yml}

\item{min_size}{Integer. Minimum number of connections to maintain (default: 1)}

\item{max_size}{Integer. Maximum number of connections allowed (default: Inf)}

\item{idle_timeout}{Integer. Seconds before idle connections are closed (default: 60)}

\item{validation_interval}{Integer. Seconds between connection health checks (default: 60)}

\item{recreate}{Logical. If TRUE, closes existing pool and creates new one (default: FALSE)}
}
\value{
A pool object that can be used like a regular DBI connection
}
\description{
Returns a connection pool for the specified database connection. Connection
pools automatically manage connection lifecycle, reuse connections across
operations, and handle cleanup. This is the recommended way to work with
databases in Framework.
}
\details{
\strong{Connection pools are stored in a package environment and reused across
calls.} You don't need to manage pool lifecycle - Framework handles it
automatically.

\strong{Advantages of connection pools:}
\itemize{
\item Automatic connection reuse (faster than creating new connections)
\item Handles connection failures gracefully (auto-reconnects)
\item Thread-safe for Shiny apps
\item No need to manually disconnect
\item Health checking prevents using stale connections
}

\strong{When to use:}
\itemize{
\item Long-running R sessions (notebooks, Shiny apps)
\item Multiple database operations
\item Any production code
}

\strong{When NOT to use:}
\itemize{
\item One-off queries (use \code{query_get()} instead)
\item Short scripts (overhead not worth it)
}
}
\keyword{internal}
