% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{rmse}
\alias{rmse}
\title{Calculate Root Mean Squared Error (RMSE)}
\usage{
rmse(y, mu)
}
\arguments{
\item{y}{Numeric vector representing the observed values.}

\item{mu}{Numeric vector representing the predicted values.}
}
\value{
Numeric value representing the RMSE.
}
\description{
This function calculates the Root Mean Squared Error (RMSE) between observed
and predicted values.
}
\details{
The RMSE is calculated using the formula:
\deqn{RMSE = \sqrt{\frac{1}{n} \sum_{i=1}^{n} (y_i - \mu_i)^2}}
Where \eqn{y} is the vector of observed values and \eqn{\mu} is the vector of
predicted values.
}
\examples{
y <- c(1, 2, 3)
mu <- c(1.1, 1.9, 3.2)
rmse(y, mu)

}
