% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVARMxID-methods-var-mx-id.R
\name{vcov.varmxid}
\alias{vcov.varmxid}
\title{Sampling Covariance Matrix of the Parameter Estimates}
\usage{
\method{vcov}{varmxid}(
  object,
  mu = TRUE,
  alpha = TRUE,
  beta = TRUE,
  nu = TRUE,
  psi = TRUE,
  theta = TRUE,
  robust = FALSE,
  ncores = NULL,
  ...
)
}
\arguments{
\item{object}{Object of class \code{varmxid}.}

\item{mu}{Logical.
If \code{mu = TRUE},
include estimates of the \code{mu} vector, if available.
If \code{mu = FALSE},
exclude estimates of the \code{mu} vector.}

\item{alpha}{Logical.
If \code{alpha = TRUE},
include estimates of the \code{alpha} vector, if available.
If \code{alpha = FALSE},
exclude estimates of the \code{alpha} vector.}

\item{beta}{Logical.
If \code{beta = TRUE},
include estimates of the \code{beta} matrix, if available.
If \code{beta = FALSE},
exclude estimates of the \code{beta} matrix.}

\item{nu}{Logical.
If \code{nu = TRUE},
include estimates of the \code{nu} vector, if available.
If \code{nu = FALSE},
exclude estimates of the \code{nu} vector.}

\item{psi}{Logical.
If \code{psi = TRUE},
include estimates of the \code{psi} matrix, if available.
If \code{psi = FALSE},
exclude estimates of the \code{psi} matrix.}

\item{theta}{Logical.
If \code{theta = TRUE},
include estimates of the \code{theta} matrix, if available.
If \code{theta = FALSE},
exclude estimates of the \code{theta} matrix.}

\item{robust}{Logical.
If \code{TRUE}, use robust (sandwich) sampling variance-covariance matrix.
If \code{FALSE}, use normal theory sampling variance-covariance matrix.}

\item{ncores}{Positive integer.
Number of cores to use.}

\item{...}{additional arguments.}
}
\value{
Returns a list of sampling variance-covariance matrices.
}
\description{
Sampling Covariance Matrix of the Parameter Estimates
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
