% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_bearer.R
\name{GuardBearer}
\alias{GuardBearer}
\title{R6 class for the Bearer authentication guard}
\description{
This class encapsulates the logic of the
\href{https://datatracker.ietf.org/doc/html/rfc6750}{Bearer authentication scheme}.
See \code{\link[=guard_bearer]{guard_bearer()}} for more information.
}
\examples{
# Create a guard of dubious quality
bearer <- GuardBearer$new(
  validate = function(token) {
    token == "abcd1234"
  },
  user_info = function(user) {
    new_user_info(
      name_given = "Thomas",
      name_middle = "Lin",
      name_family = "Pedersen"
    )
  }
)

}
\section{Super class}{
\code{\link[fireproof:Guard]{fireproof::Guard}} -> \code{GuardBearer}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{open_api}}{An OpenID compliant security scheme description}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GuardBearer-new}{\code{GuardBearer$new()}}
\item \href{#method-GuardBearer-check_request}{\code{GuardBearer$check_request()}}
\item \href{#method-GuardBearer-reject_response}{\code{GuardBearer$reject_response()}}
\item \href{#method-GuardBearer-clone}{\code{GuardBearer$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="forbid_user"><a href='../../fireproof/html/Guard.html#method-Guard-forbid_user'><code>fireproof::Guard$forbid_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="register_handler"><a href='../../fireproof/html/Guard.html#method-Guard-register_handler'><code>fireproof::Guard$register_handler()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBearer-new"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBearer-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBearer$new(
  validate,
  user_info = NULL,
  realm = "private",
  allow_body_token = TRUE,
  allow_query_token = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{validate}}{A function that will be called with the arguments
\code{token}, \code{realm}, \code{request}, and \code{response} and returns \code{TRUE} if the token
is valid, and \code{FALSE} otherwise. If the function returns a character vector
it is considered to be authenticated and the return value will be understood
as scopes the user is granted.}

\item{\code{user_info}}{A function to extract user information from the
token. It is called with a single argument: \code{token} which is the token
used for the successful authentication. The function should return a new
\link[=new_user_info]{user_info} list.}

\item{\code{realm}}{The realm this authentication corresponds to. Will be returned
to the client on a failed authentication attempt to inform them of the
credentials required, though most often these days it is kept from the user.}

\item{\code{allow_body_token}}{Should it be allowed to pass the token in the request
body as a query form type with the \code{access_token} name. Defaults to \code{TRUE}
but you can turn it off to force the client to use the \code{Authorization}
header.}

\item{\code{allow_query_token}}{Should it be allowed to pass the token in the query
string of the url with the \code{access_token} name. Default to \code{FALSE} due to
severe security implications but can be turned on if you have very
well-thought-out reasons to do so.}

\item{\code{name}}{The name of the authentication}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBearer-check_request"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBearer-check_request}{}}}
\subsection{Method \code{check_request()}}{
A function that validates an incoming request, returning
\code{TRUE} if it is valid and \code{FALSE} if not. It fetches the token from the
request according to the \code{allow_body_token} and \code{allow_query_token}
settings and validates it according to the provided function. If the
token is present multiple times it will fail with \code{400} as this is not
allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBearer$check_request(request, response, keys, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to validate as a \link[reqres:Request]{Request}
object}

\item{\code{response}}{The corresponding response to the request as a
\link[reqres:Response]{Response} object}

\item{\code{keys}}{A named list of path parameters from the path matching}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBearer-reject_response"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBearer-reject_response}{}}}
\subsection{Method \code{reject_response()}}{
Upon rejection this scheme sets the response status to \code{401}
and sets the \code{WWW-Authenticate} header to \verb{Bearer realm="<realm>"}. If
any scope is provided by the endpoint it will be appended as
\verb{, scope="<scope>"} and if the token is present but invalid, it will
append \verb{, error="invalid_token"}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBearer$reject_response(response, scope, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{The response object}

\item{\code{scope}}{The scope of the endpoint}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBearer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBearer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBearer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
