% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_read_fiora.R
\name{read_fiora}
\alias{read_fiora}
\title{Read a fiora result file (mgf) into a R object.}
\usage{
read_fiora(fl, fmt = c("list", "df", "Spectra"))
}
\arguments{
\item{fl}{file.}

\item{fmt}{A named list object is returned if not specified otherwise. Set 'fmt=df'
to simplify the return value to a data frame. Use 'fmt=Spectra' to convert to
a [Spectra::Spectra()] object.}
}
\value{
A result list of length = n_compounds containing metadata fields as
    sub-lists and the predicted MS^2 spectrum as sub-list `spec`. You can set
    parameter `fmt` to 'df' in which case each compound list will be coerced
    to a data frame row (spectra will be encoded as 'mz1:int1 mz2:int2 ...'
    and information regarding SMILES, adduct or formula per peak will be lost).
}
\description{
Allows to import a `fioRa` output file (msp like format) to a list
    like format or simplified to a data frame or Spectra object.
}
\examples{
fl <- system.file("extdata/annotated_output.mgf", package = "fioRa")

# read as data.frame (return a simplified version)
str(fioRa::read_fiora(fl = fl, fmt = "df"))

\donttest{
  # read as a list (standard case)
  fioRa::read_fiora(fl = fl)

  # read as Spectra object (requires Spectra-package)
  if (requireNamespace("Spectra", quietly = TRUE)) {
    fioRa::read_fiora(fl = fl, fmt = "Spectra")
   }
}

}
\seealso{
[Spectra::Spectra()]
}
