% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findn_maruo.R
\name{findn_maruo}
\alias{findn_maruo}
\title{Find the Sample Size Using the Algorithm by Maruo et al.}
\usage{
findn_maruo(fun, targ, start = 10, k = 100, ...)
}
\arguments{
\item{fun}{A function that estimates the power of a trial. The function has
to take at least two arguments: n, the sample size and k, the number of
iterations.}

\item{targ}{The target power. Must be either 0.8 or 0.9.}

\item{start}{Starting value for the algorithm. Maruo et al. suggest to
use 10.}

\item{k}{Number of trial simulations to use in \code{fun} to estimate the power.}

\item{...}{Further optional arguments.}
}
\value{
\code{findn_maruo} returns a list containing the point estimate
for the sample size and a list of all sample sizes that for which the trial
function was evaluated.
}
\description{
\code{findn_maruo} estimates the sample size for a certain target function 
based on repeated simulations using a model based approach proposed by Maruo 
et al. (2018).
}
\examples{
# Function that simulates the outcomes of a two-sample t-test
ttest <- function(n, k, mu1 = 0, mu2 = 1, sd = 2) {
  sample1 <- matrix(rnorm(n = ceiling(n) * k, mean = mu1, sd = sd),
    ncol = k)
  mean1 <- apply(sample1, 2, mean)
  sd1_hat <- apply(sample1, 2, sd)
  sample2 <- matrix(rnorm(n = ceiling(n) * k, mean = mu2, sd = sd),
    ncol = k)
  mean2 <- apply(sample2, 2, mean)
  sd2_hat <- apply(sample2, 2, sd)
  sd_hat <- sqrt((sd1_hat^2 + sd2_hat^2) / 2)
  teststatistic <- (mean1 - mean2) / (sd_hat * sqrt(2 / n))
  crit <- qt(1 - 0.025, 2 * n - 2)
  return(mean(teststatistic < -crit))
}

findn_maruo(fun = ttest, targ = 0.8)
}
\references{
Maruo, K., Tada, K., Ishil, R. and Gosho M. (2018) An
  Efficient Procedure for Calculating Sample Size Through
  Statistical Simulations, Statistics in Biopharmaceutical Research
  10, 1-8.
}
