% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{felt_add_map_elements}
\alias{felt_add_map_elements}
\title{Add Elements to Existing Map}
\usage{
felt_add_map_elements(map_id, elements, clean = TRUE)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{elements}{a \link[sf:sf]{sf::sf} object or a path to a geojson file}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
a \link[tibble:tibble]{tibble::tibble} with the elements added
}
\description{
Add Elements to Existing Map
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
elem <- felt_add_map_elements(map_id = 'Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA',
                    elements = fs::path_package('feltr',  'bbox.geojson'))
elem
# and delete layer
felt_delete_map_elements(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA', element_id = elem$felt_id)
\dontshow{\}) # examplesIf}
}
\concept{edits}
