% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fcrr.R
\name{predict.fcrr}
\alias{predict.fcrr}
\title{Cumulative Incidence Function Estimation}
\usage{
\method{predict}{fcrr}(
  object,
  newdata,
  getBootstrapVariance = TRUE,
  var.control = varianceControl(B = 100, useMultipleCores = FALSE),
  type = "none",
  alpha = 0.05,
  tL = NULL,
  tU = NULL,
  ...
)
}
\arguments{
\item{object}{Output from \code{fcrr} object.}

\item{newdata}{A set of covariate values to predict the CIF.}

\item{getBootstrapVariance}{Logical: Calculate variance for CIF via bootstrap.}

\item{var.control}{List of variance parameters from \code{varianceControl()}.}

\item{type}{Confidence intervals or confidence bands.}

\item{alpha}{Significance level to compute intervals or bands}

\item{tL}{Lower time for band estimation.}

\item{tU}{Upper time for band estimation.}

\item{...}{additional arguments affecting the fastCrr procedure.}

\item{B}{Number of bootstrap samples for variance estimation.}
}
\value{
Returns a list of class \code{predict.fcrr}.
\item{ftime}{Unique observed failure times}
\item{CIF}{predicted CIF at time \code{ftime}}
\item{lower}{lower interval/band limit}
\item{upper}{upper interval/band limit}
\item{type}{same as original argument}
}
\description{
Predicts cumulative incidence function from a \code{fcrr} object.
}
\details{
Calculates the CIF using \code{fcrr} output conditional on \code{newdata}.
}
\examples{

library(fastcmprsk)
set.seed(10)
ftime <- rexp(200)
fstatus <- sample(0:2, 200, replace = TRUE)
cov <- matrix(runif(1000), nrow = 200)
dimnames(cov)[[2]] <- c('x1','x2','x3','x4','x5')
fit <- fastCrr(Crisk(ftime, fstatus) ~ cov, returnDataFrame = TRUE)
cov2 <- rnorm(5)
predict(fit, newdata = cov2)

}
\references{
Fine J. and Gray R. (1999) A proportional hazards model for the subdistribution of a competing risk.  \emph{JASA} 94:496-509.
}
