% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_lse_fitted}
\alias{qr_lse_fitted}
\title{Compute fitted values using QR decomposition}
\usage{
qr_lse_fitted(X, y)
}
\arguments{
\item{X}{numeric matrix of dimension \eqn{n \times p}.}

\item{y}{numeric response vector of length \eqn{n}.}
}
\value{
a numeric vector of fitted values \eqn{\hat y}.
}
\description{
Computes the fitted values \eqn{\hat y = X\hat\beta} for a linear
least-squares problem using a QR decomposition computed internally.
}
\details{
The QR decomposition of \eqn{X} is computed internally. The fitted
values are obtained as
\deqn{\widehat y = Q Q^\top y}
without explicitly forming the orthogonal matrix \eqn{Q}.

This function is intended as a convenience wrapper for least-squares
computations when the explicit QR factors are not required.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

yhat1 <- fastQR::qr_lse_fitted(X, y)

## reference computation
yhat2 <- base::qr.fitted(base::qr(X), y)

max(abs(yhat1 - yhat2))

}
