% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COR_main.R
\name{COR}
\alias{COR}
\title{Correlation-Based Clustering Tree}
\usage{
COR(X, Y, control = list())
}
\arguments{
\item{X}{A numeric matrix of covariates with dimension \eqn{N \times p},
where \eqn{N} is the number of time series and \eqn{p} is the number of features.
Each row corresponds to the covariates for one time series.}

\item{Y}{A numeric matrix of time series data with dimension \eqn{T \times N},
where \eqn{T} is the length of each series. Each column represents one time series.}

\item{control}{A list of control parameters for tree construction:
\describe{
  \item{\code{minsplit}}{Minimum number of observations required to attempt
    a split. Default: \code{90}.}
  \item{\code{minbucket}}{Minimum number of observations in any terminal node.
    Default: \code{30}.}
  \item{\code{alpha}}{Significance level for the permutation test.
    Default: \code{0.01}.}
  \item{\code{R}}{Number of permutations for the hypothesis test.
    Default: \code{199}.}
  \item{\code{parallel}}{Logical; if \code{TRUE}, enables parallel computation
    for permutation tests. Default: \code{FALSE}.}
  \item{\code{n_cores}}{Number of cores for parallel processing.
    If \code{NULL} (default), uses \code{detectCores() - 1}.}
}}
}
\value{
An object of class \code{"FACT"} containing:
  \describe{
    \item{\code{frame}}{A data frame describing the tree structure, with one row
      per node containing split variable, split value, test statistic, and p-value.
      A smaller test statistic suggests more heterogeneity between child nodes.}
    \item{\code{membership}}{An integer vector of length \eqn{N} indicating
      the terminal node assignment for each observation.}
    \item{\code{control}}{The control parameters used.}
    \item{\code{terms}}{Metadata including covariate names and data dimensions.}
  }
}
\description{
Builds a binary tree for clustering time series data based on covariates.
The splitting criterion minimizes the average absolute Pearson correlation
between time series across child nodes.
}
\details{
The algorithm recursively partitions the data by finding splits that minimize
the average absolute correlation between time series in different child nodes.
Statistical significance of each split is assessed via a permutation test.

At each node, the optimal split is found by exhaustively searching over all
covariates and candidate split points. The permutation test shuffles the
time series labels to generate a null distribution for the test statistic.
}
\examples{
# Generate synthetic data
data <- gendata(seed = 42, T = 100, N = c(50, 50, 50, 50))

# Build correlation-based tree
result <- COR(data$X, data$Y, control = list(R = 99, alpha = 0.05))

# Examine results
print(result)
plot(result)
table(result$membership, data$group)

}
\seealso{
\code{\link{FACT}} for factor model-based clustering,
\code{\link{gendata}} for generating synthetic data,
\code{\link{print.FACT}} and \code{\link{plot.FACT}} for visualization.
}
