% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorplot.R
\name{plot.factorplot}
\alias{plot.factorplot}
\title{Plot method for objects of class factorplot}
\usage{
\method{plot}{factorplot}(
  x,
  ...,
  abbrev.char = 100,
  print.est = TRUE,
  print.se = TRUE,
  text.nudge = 0.1,
  text.args = list(),
  remove.caption = FALSE
)
}
\arguments{
\item{x}{An object of class factorplot, produced by
\code{\link[factorplot]{factorplot}}.}

\item{...}{Other arguments to be passed to plot, currently not implemented}

\item{abbrev.char}{The number of characters that should be used to
abbreviate the levels of the factor.  Set to a large value for unabbreviated
names.}

\item{print.est}{logical argument indicating whether the estimates should be
printed in the boxes}

\item{print.se}{logical argument indicating whether the standard errors
should be printed in the boxes}

\item{text.nudge}{Scalar giving the value the estimate text will be moved in the positive direction on y and the 
standard error text will be moved in the negative direction on y.}

\item{text.args}{A list of other arguments to be passed to `geom_text()`, such as `size` or `color`.}

\item{remove.caption}{Logical indicating whether the caption should be removed from the plot.}
}
\value{
\item{a graph}{For m categories, the plot returns an m-1 x m-1 matrix
where the nexus of the row and column values represent the pairwise differences
between the row and column values along with the standard error of the difference
on the linear scale (unless a transformation is performed).}
}
\description{
Creates a plot akin to an upper-triangular levelplot (though using
\code{plot} rather than \code{levelplot}) where the coloring of the squares
represents significance and text inside the squares represents the pairwise
difference and its correspopnding standard error.
}
\examples{

est1 <- log(c(1.00,2.12,1.44,1.31,1.44,
     1.46,0.90))
var1 <- c(0.242,0.096,0.156,0.140,
     0.380,0.484,0.375)^2
names(est1) <- c(
     "Normal & superficial gastritis", 
     "Chronic gastritis", 
     "Chronic atrophic gastritits", 
     "Intestinal metaplasia I", 
     "Intestinal metaplasia II", 
     "Intestinal metaplasia III", 
     "Dysplasia")

plummer_fp1 <- factorplot(est1, var=var1, resdf=Inf)
plot(plummer_fp1, trans="exp", abbrev.char = 100)

}
\seealso{
\code{\link[factorplot]{factorplot}}
}
\author{
Dave Armstrong
}
