% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{refit.RW}
\alias{refit.RW}
\title{Refit a lag walk model}
\usage{
\method{refit}{RW}(object, new_data, specials = NULL, reestimate = FALSE, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{reestimate}{If \code{TRUE}, the lag walk model will be re-estimated
to suit the new data.}

\item{...}{Other arguments passed to methods}
}
\description{
Applies a fitted random walk model to a new dataset.
}
\details{
The models \code{NAIVE} and \code{SNAIVE} have no specific model parameters. Using \code{refit}
for one of these models will provide the same estimation results as one would
use \code{fabletools::model(NAIVE(...))} (or \code{fabletools::model(SNAIVE(...))}.
}
\examples{
lung_deaths_male <- as_tsibble(mdeaths)
lung_deaths_female <- as_tsibble(fdeaths)

fit <- lung_deaths_male \%>\%
  model(RW(value ~ drift()))

report(fit)

fit \%>\%
  refit(lung_deaths_female) \%>\%
  report()
}
