% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_palettes.R
\name{compile_palettes}
\alias{compile_palettes}
\title{compile_palettes(): Compile JSON palettes into RDS}
\usage{
compile_palettes(palettes_dir, output_rds, log = TRUE)
}
\arguments{
\item{palettes_dir}{Character. Folder containing subdirs: sequential/, diverging/, qualitative/ (required)}

\item{output_rds}{Character. Path to save compiled RDS file (required). Use tempdir() for examples/tests.}

\item{log}{Logical. Whether to log compilation events. Default: TRUE}
}
\value{
Invisibly returns RDS file path (character)
}
\description{
Read JSON files under \verb{palettes_dir/}, validate content, and compile into a structured RDS file.
}
\examples{
\donttest{
# Compile palettes using temporary directory:
compile_palettes(
  palettes_dir = system.file("extdata", "palettes", package = "evanverse"),
  output_rds = file.path(tempdir(), "palettes.rds")
)
}

}
