% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pdiff_one.R
\name{estimate_pdiff_one}
\alias{estimate_pdiff_one}
\title{Estimates for a single-group design with a categorical outcome
variable compared to a reference or population value.}
\usage{
estimate_pdiff_one(
  data = NULL,
  outcome_variable = NULL,
  comparison_cases = NULL,
  comparison_n = NULL,
  reference_p = 0,
  case_label = 1,
  outcome_variable_name = "My outcome variable",
  conf_level = 0.95,
  count_NA = FALSE
)
}
\arguments{
\item{data}{For raw data - a dataframe or tibble}

\item{outcome_variable}{For raw data - The column name of the outcome
variable, which must be a factor, or a vector that is a factor}

\item{comparison_cases}{For summary data, a numeric integer > 0}

\item{comparison_n}{For summary data, a numeric integer >= count}

\item{reference_p}{Reference proportion, numeric >=0 and <=1}

\item{case_label}{An optional numeric or character label for the
count level.}

\item{outcome_variable_name}{Optional friendly name for the outcome variable.
Defaults to 'My outcome variable' or the outcome variable column name if a
data frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{count_NA}{Logical to count NAs (TRUE) in total N or not (FALSE)}
}
\value{
Returns an object of class esci_estimate
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{outcome_variable_level} -
\item \emph{cases} -
\item \emph{n} -
\item \emph{P} -
\item \emph{P_LL} -
\item \emph{P_UL} -
\item \emph{P_SE} -
\item \emph{P_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{es_proportion_difference}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{case_label} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{effect_size_adjusted} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{cases} -
\item \emph{n} -
\item \emph{type} -
}
}
}
\description{
Returns object
\code{estimate_pdiff_one} is suitable for a single-group design
(between subjects) with a categorical outcome variable.  It calculates
the effect sizes with respect to a reference or population proportion
(default value of 0).  It returns the estimated difference between the
in proportion from the reference/population value.  You can pass raw data or
summary data.
}
\details{
Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_pdiff]{plot_pdiff()}} and you can test hypotheses with
\code{\link[=test_pdiff]{test_pdiff()}}.

The estimated proportion differences are from \code{\link[statpsych:ci.prop]{statpsych::ci.prop()}} (named
ci.prop in statpsych < 1.6).
}
\examples{
# From raw data
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_pdiff_one(
  esci::data_campus_involvement,
  CommuterStatus,
  reference_p = 0.50
)

# To visualize the estimate
myplot_from_raw <- esci::plot_pdiff(estimate_from_raw)

# To conduct a hypothesis test
res_htest_from_raw <- esci::test_pdiff(estimate_from_raw)


# From summary data
estimate_from_summary  <- esci::estimate_pdiff_one(
  comparison_cases = 8,
  comparison_n = 22,
  reference_p = 0.5
)

# To visualize the estimate
myplot_from_summary <- esci::plot_pdiff(estimate_from_summary)

# To conduct a hypothesis test
res_htest_from_summary <- esci::test_pdiff(estimate_from_summary)


}
