% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_RR_on_list}
\alias{compute_RR_on_list}
\title{Function used to compute the Relative Risk on a list of cocktails}
\usage{
compute_RR_on_list(cocktails, ATCtree, observations, num_thread = 1L)
}
\arguments{
\item{cocktails}{: A list containing cocktails in the form of vector of integers (ATC index)}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{observations}{: observation of the AE based on the medications of each patients
(a DataFrame containing the medication on the first column and the ADR (boolean) on the second)
on which we want to compute the risk distribution}

\item{num_thread}{: Number of thread to run in parallel if openMP is available, 1 by default}
}
\value{
RR score among "cocktails" parameters
}
\description{
Function used to compute the Relative Risk on a list of cocktails
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

cocktails = list(c(561, 904),
               c(1902, 4585))

RR_of_cocktails = compute_RR_on_list(cocktails = cocktails,
                              ATCtree = ATC_Tree_UpperBound_2024, 
                              observations = FAERS_myopathy)
}
}
