% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_fns.R
\name{ebnm_npmle}
\alias{ebnm_npmle}
\title{Solve the EBNM problem using the family of all distributions}
\usage{
ebnm_npmle(
  x,
  s = 1,
  scale = "estimate",
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default(),
  optmethod = NULL,
  control = NULL
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{scale}{The nonparametric family of all distributions is
approximated via a finite mixture of point masses
\deqn{\pi_1 \delta_{\mu_1} + \ldots + \pi_K \delta_{\mu_K},}
where parameters \eqn{\pi_k} are estimated and the point masses are
evenly spaced over \eqn{(\mu_1, \mu_K)}. By taking a sufficiently dense
grid of point masses, one can obtain an arbitrarily good
approximation. The distance between successive point masses can be
specified by the user via parameter
\code{scale}, in which case the argument should be a scalar specifying the
distance \eqn{d = \mu_2 - \mu_1 = \cdots = \mu_K - \mu_{K - 1}};
alternatively, if \code{scale = "estimate"}, then \code{ebnm} sets the grid
via function \code{\link{ebnm_scale_npmle}}.}

\item{g_init}{The prior distribution \eqn{g}. Usually this is left
unspecified (\code{NULL}) and estimated from the data. However, it can be
used in conjuction with \code{fix_g = TRUE} to fix the prior (useful, for
example, to do computations with the "true" \eqn{g} in simulations). If
\code{g_init} is specified but \code{fix_g = FALSE}, \code{g_init}
specifies the initial value of \eqn{g} used during optimization. This has
the side effect of fixing the \code{scale} parameter. When supplied,
\code{g_init} should be an object of class \code{\link[ashr]{normalmix}}
or an \code{ebnm} object in which the fitted
prior is an object of class \code{normalmix}.}

\item{fix_g}{If \code{TRUE}, fix the prior \eqn{g} at \code{g_init} instead
of estimating it.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}

\item{optmethod}{A string specifying which optimization function is to be
used. Options are provided by package
\code{ashr}. The default method uses the mix-SQP algorithm implemented in
the \code{mixsqp} package. See the \code{\link[ashr]{ash}} function
documentation for other options. It is also possible to
specify \code{optmethod = "REBayes"}, which uses function
\code{\link[REBayes]{GLmix}} in the \code{REBayes} package
to estimate the NPMLE rather than \code{ashr}. Note that \code{REBayes}
requires installation of the commercial interior-point solver MOSEK; for
details, see \code{\link[REBayes]{KWDual}} (the core optimization routine
for the \code{REBayes} package).}

\item{control}{A list of control parameters to be passed to the
optimization function specified by parameter \code{optmethod}.}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}}.}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. The sampler takes a single
        parameter \code{nsamp}, the number of posterior samples to return per
        observation.}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem using the family
  of all distributions. Identical to function \code{\link{ebnm}} with argument
  \code{prior_family = "npmle"}. For details about the model, see
  \code{\link{ebnm}}.
}
\seealso{
See \code{\link{ebnm}} for examples of usage and model details.

  Available S3 methods include \code{\link{coef.ebnm}},
  \code{\link{confint.ebnm}},
  \code{\link{fitted.ebnm}}, \code{\link{logLik.ebnm}},
  \code{\link{nobs.ebnm}}, \code{\link{plot.ebnm}},
  \code{\link{predict.ebnm}}, \code{\link{print.ebnm}},
  \code{\link{print.summary.ebnm}}, \code{\link{quantile.ebnm}},
  \code{\link{residuals.ebnm}}, \code{\link{simulate.ebnm}},
  \code{\link{summary.ebnm}}, and \code{\link{vcov.ebnm}}.
}
