% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_mcc_f1}
\alias{calculate_mcc_f1}
\title{Calculate MCC and F1 score}
\usage{
calculate_mcc_f1(observed, predicted)
}
\arguments{
\item{observed}{logical or 0/1; the observed binary response.}

\item{predicted}{logical or 0/1; the predicted binary response. This will typically
need to be generated by applying a threshold to the continuous predicted
response.}
}
\value{
A list with two elements: \code{mcc} and \code{f1}.
}
\description{
Given binary observed and predicted response, estimate Matthews correlation
coefficient (MCC) and the F1 score.
}
\examples{
obs <- c(rep(1L, 1000L), rep(0L, 10000L))
pred <- c(rbeta(300L, 12, 2), rbeta(700L, 3, 4), rbeta(10000L, 2, 3))
calculate_mcc_f1(obs > 0, pred > 0.5)
}
