test_that("scriptINULL produces correct output 1 lv", {

  dvn <- scrapeVarCross(dat = commitmentQ,
                        x_order = "spi", x_stem = "sat.g", x_delim1 = ".", x_delim2="_",
                        distinguish_1="1", distinguish_2="2")


  expect_equal(scriptINULL(dvn, lvxname = "Sat", lvyname = "Com"),
               "#Equated Means\nsat.g.1_1 ~ tx1*1\nsat.g.1_2 ~ tx2*1\nsat.g.1_3 ~ tx3*1\nsat.g.1_4 ~ tx4*1\nsat.g.1_5 ~ tx5*1\nsat.g.2_1 ~ tx1*1\nsat.g.2_2 ~ tx2*1\nsat.g.2_3 ~ tx3*1\nsat.g.2_4 ~ tx4*1\nsat.g.2_5 ~ tx5*1\n\n#Equated Variances\nsat.g.1_1 ~~ thx1*sat.g.1_1\nsat.g.1_2 ~~ thx2*sat.g.1_2\nsat.g.1_3 ~~ thx3*sat.g.1_3\nsat.g.1_4 ~~ thx4*sat.g.1_4\nsat.g.1_5 ~~ thx5*sat.g.1_5\nsat.g.2_1 ~~ thx1*sat.g.2_1\nsat.g.2_2 ~~ thx2*sat.g.2_2\nsat.g.2_3 ~~ thx3*sat.g.2_3\nsat.g.2_4 ~~ thx4*sat.g.2_4\nsat.g.2_5 ~~ thx5*sat.g.2_5\n\n#No Covariances\nsat.g.1_1 ~~ 0*sat.g.1_2+0*sat.g.1_3+0*sat.g.1_4+0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.1_2 ~~ 0*sat.g.1_3+0*sat.g.1_4+0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.1_3 ~~ 0*sat.g.1_4+0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.1_4 ~~ 0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.1_5 ~~ 0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.2_1 ~~ 0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.2_2 ~~ 0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5\nsat.g.2_3 ~~ 0*sat.g.2_4+0*sat.g.2_5\nsat.g.2_4 ~~ 0*sat.g.2_5"
               )
})

test_that("scriptINULL produces correct output 2 lv", {

  dvn <- scrapeVarCross(dat = commitmentQ,
                        x_order = "spi", x_stem = "sat.g", x_delim1 = ".", x_delim2="_",
                        y_order="spi", y_stem="com", y_delim1 = ".", y_delim2="_",
                        distinguish_1="1", distinguish_2="2")


  expect_equal(scriptINULL(dvn, lvxname = "Sat", lvyname = "Com"),
               "#Equated Means\nsat.g.1_1 ~ tx1*1\nsat.g.1_2 ~ tx2*1\nsat.g.1_3 ~ tx3*1\nsat.g.1_4 ~ tx4*1\nsat.g.1_5 ~ tx5*1\nsat.g.2_1 ~ tx1*1\nsat.g.2_2 ~ tx2*1\nsat.g.2_3 ~ tx3*1\nsat.g.2_4 ~ tx4*1\nsat.g.2_5 ~ tx5*1\ncom.1_1 ~ ty1*1\ncom.1_2 ~ ty2*1\ncom.1_3 ~ ty3*1\ncom.1_4 ~ ty4*1\ncom.1_5 ~ ty5*1\ncom.2_1 ~ ty1*1\ncom.2_2 ~ ty2*1\ncom.2_3 ~ ty3*1\ncom.2_4 ~ ty4*1\ncom.2_5 ~ ty5*1\n\n#Equated Variances\nsat.g.1_1 ~~ thx1*sat.g.1_1\nsat.g.1_2 ~~ thx2*sat.g.1_2\nsat.g.1_3 ~~ thx3*sat.g.1_3\nsat.g.1_4 ~~ thx4*sat.g.1_4\nsat.g.1_5 ~~ thx5*sat.g.1_5\nsat.g.2_1 ~~ thx1*sat.g.2_1\nsat.g.2_2 ~~ thx2*sat.g.2_2\nsat.g.2_3 ~~ thx3*sat.g.2_3\nsat.g.2_4 ~~ thx4*sat.g.2_4\nsat.g.2_5 ~~ thx5*sat.g.2_5\ncom.1_1 ~~ thy1*com.1_1\ncom.1_2 ~~ thy2*com.1_2\ncom.1_3 ~~ thy3*com.1_3\ncom.1_4 ~~ thy4*com.1_4\ncom.1_5 ~~ thy5*com.1_5\ncom.2_1 ~~ thy1*com.2_1\ncom.2_2 ~~ thy2*com.2_2\ncom.2_3 ~~ thy3*com.2_3\ncom.2_4 ~~ thy4*com.2_4\ncom.2_5 ~~ thy5*com.2_5\n\n#No Covariances\nsat.g.1_1 ~~ 0*sat.g.1_2+0*sat.g.1_3+0*sat.g.1_4+0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.1_2 ~~ 0*sat.g.1_3+0*sat.g.1_4+0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.1_3 ~~ 0*sat.g.1_4+0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.1_4 ~~ 0*sat.g.1_5+0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.1_5 ~~ 0*sat.g.2_1+0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.2_1 ~~ 0*sat.g.2_2+0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.2_2 ~~ 0*sat.g.2_3+0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.2_3 ~~ 0*sat.g.2_4+0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.2_4 ~~ 0*sat.g.2_5+0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\nsat.g.2_5 ~~ 0*com.1_1+0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.1_1 ~~ 0*com.1_2+0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.1_2 ~~ 0*com.1_3+0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.1_3 ~~ 0*com.1_4+0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.1_4 ~~ 0*com.1_5+0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.1_5 ~~ 0*com.2_1+0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.2_1 ~~ 0*com.2_2+0*com.2_3+0*com.2_4+0*com.2_5\ncom.2_2 ~~ 0*com.2_3+0*com.2_4+0*com.2_5\ncom.2_3 ~~ 0*com.2_4+0*com.2_5\ncom.2_4 ~~ 0*com.2_5"
               )
})
