% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_write.R
\name{ddbs_write_vector}
\alias{ddbs_write_vector}
\title{Write an SF Object to a DuckDB Database}
\usage{
ddbs_write_vector(
  conn,
  data,
  name,
  overwrite = FALSE,
  temp_view = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{data}{A \code{sf} object to write to the DuckDB database, or the path to
a local file that can be read with \code{ST_READ}}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{temp_view}{If \code{TRUE}, registers the \code{sf} object as a temporary Arrow-backed database 'view' using \code{ddbs_register_vector} instead of creating a persistent table. This is much faster but the view will not persist. Defaults to \code{FALSE}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
TRUE (invisibly) for successful import
}
\description{
This function writes a Simple Features (SF) object into a DuckDB database as a new table.
The table is created in the specified schema of the DuckDB database.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## create random points
random_points <- data.frame(
  id = 1:5,
  x = runif(5, min = -180, max = 180),  # Random longitude values
  y = runif(5, min = -90, max = 90)     # Random latitude values
)

## convert to sf
sf_points <- st_as_sf(random_points, coords = c("x", "y"), crs = 4326)

## insert data into the database
ddbs_write_vector(conn, sf_points, "points")

## read data back into R
ddbs_read_vector(conn, "points", crs = 4326)

## disconnect from db
dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
