% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_data_summary.R
\name{dtms_data_summary}
\alias{dtms_data_summary}
\title{Summarize data in transition format}
\usage{
dtms_data_summary(
  data,
  dtms = NULL,
  fromvar = "from",
  tovar = "to",
  weights = NULL
)
}
\arguments{
\item{data}{Data frame, as created with \code{dtms_format}.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{fromvar}{Character (optional), name of variable in `data` with starting state. Default is "from".}

\item{tovar}{Character (optional), name of variable  in `data`with receiving state. Default is "to".}

\item{weights}{Character (optional), name of variable in `data` with weights. Default is NULL.}
}
\value{
A data frame
}
\description{
Returns a data frame with number of observed transitions (column COUNT),
relative proportion of a transition relative to all transitions (column
PROP), and raw transition probabilities Pr(j|i) (column PROB).
}
\examples{
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
dtms_data_summary(estdata)
}
