% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_lifetraits.R
\name{dRGetMetrics}
\alias{dRGetMetrics}
\title{Life traits from Thermal Performance Curve}
\usage{
dRGetMetrics(
  nlsDR,
  prec = 0.1,
  lowTempLim = 0,
  highTempLimit = 60,
  devLimit = 0.01,
  printOut = FALSE
)
}
\arguments{
\item{nlsDR}{The object obtained from the \code{devRateModel} function.}

\item{prec}{The precision for the temperature (default = 0.1 degree
celsius).}

\item{lowTempLim}{The minimum temperature for the metrics (default = 0
degree celsius).}

\item{highTempLimit}{The maximum temperature for the metrics (default = +60
degree celsius).}

\item{devLimit}{The development rate considered as null (default = 0.01).}

\item{printOut}{A logical to print the result (default = FALSE).}
}
\value{
A matrix with one column and one row for each metric. The metrics
  names are the row names.
}
\description{
Compute life traits from a Thermal Performance Curve
}
\examples{
rawDevEggs <- matrix(
   c(10, 0.031, 10, 0.039, 15, 0.047, 15, 0.059, 15.5,
   0.066, 13, 0.072, 16, 0.083, 16, 0.100, 17, 0.100, 20, 0.100, 20,
   0.143, 25, 0.171, 25, 0.200, 30, 0.200, 30, 0.180, 35, 0.001
), ncol = 2, byrow = TRUE)
mEggs <- devRateModel(
   eq = taylor_81,
   temp = rawDevEggs[,1],
   devRate = rawDevEggs[,2],
   startValues = list(Rm = 0.05, Tm = 30, To = 5)
)
myMetrics <- dRGetMetrics(nlsDR = mEggs, printOut = TRUE)
}
