% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_perm_dri.R
\name{summarize_perm_dri}
\alias{summarize_perm_dri}
\title{Summarize DRI Permutation Test Results}
\usage{
summarize_perm_dri(perms, type = "common")
}
\arguments{
\item{perms}{results of the permutation test generated by \code{permute_dri()}}

\item{type}{which type of statistics to summarize (e.g., \code{"common"},
\code{"robust"}, \code{"mean"})}
}
\value{
summary of permutation test
}
\description{
\code{summarize_perm_dri} summarizes the results of a permutation test done using
\code{permute_dri(..., summary = FALSE)}; useful for summarizing results after
plotting permutation results
}
\examples{

# get pre-deliberation (stage_id == 1) data from Zukunft case
data <- human_data[human_data$stage_id == 1 & human_data$case == "Zukunft", ]

# create permutations
perms <- permute_dri(data, iterations = 100, summary = FALSE)

summarize_perm_dri(perms)

}
\seealso{
\code{\link[=permute_dri]{permute_dri()}} for generating the \code{perms} parameter

\code{\link[rstatix:get_summary_stats]{rstatix::get_summary_stats()}} for values of \code{type}
}
