% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dri_ic.R
\name{get_dri_ic}
\alias{get_dri_ic}
\title{Get DRI Intersubjective Consistency (IC)}
\usage{
get_dri_ic(data)
}
\arguments{
\item{data}{the raw DRI survey response data}
}
\value{
dataframe with \code{pnums} or participant numbers, \code{pnum1} and \code{pnum2},
or the unique number of participant 1 and 2, respectively, \code{ccor} and \code{pcor}, or
the correlation between considerations statement ratings and policy
preference rankings, respecively, and \code{dj}, or the modal orthogonal distance
\code{d} for a given  pair \code{j}
}
\description{
\code{get_dri_ic} calculates the intersubjective consistency (IC) between
deliberation participants using their DRI survey responses
}
\examples{

# get post-deliberation (stage_id == 2) data from Zukunft case
data <- human_data[human_data$stage_id == 2 & human_data$case == "Zukunft", ]
get_dri_ic(data)

}
\seealso{
\link{human_data} for raw survey response data formatting

Other DRI survey methods: 
\code{\link{get_dri_alpha}()},
\code{\link{get_dri_case}()}
}
\concept{DRI survey methods}
