% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subset_drugbank_dvobject}
\alias{subset_drugbank_dvobject}
\title{Subset a DrugBank dvobject by a vector of DrugBank IDs}
\usage{
subset_drugbank_dvobject(dvobject, drug_ids)
}
\arguments{
\item{dvobject}{The dvobject from `parseDrugBank()`.}

\item{drug_ids}{A character vector of `drugbank_id` values to keep.}
}
\value{
A new, smaller dvobject with the same structure and attributes.
}
\description{
Subset a DrugBank dvobject by a vector of DrugBank IDs
}
\details{
Intelligently filters a DrugBank dvobject to retain only the data associated
with a specified list of drugbank_ids. It correctly handles the deep,
multi-level nested structure of the entire object, including the complex
relationships within the `cett` list.
}
\examples{
\dontrun{
library(dbparser)
one_drug <- subset_drugbank_dvobject(dvobject = dbdataset::drugbank,
                                     drug_ids = "DB00001")
}
}
\seealso{
Other utility: 
\code{\link{add_database_info}()},
\code{\link{show_dvobject_metadata}()},
\code{\link{subset_onsides_dvobject}()}
}
\concept{utility}
