% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{drug_products}
\alias{drug_products}
\title{Drug Products parser}
\usage{
drug_products()
}
\value{
a tibble with 32 variables:
\describe{
 \item{name}{The proprietary name(s) provided by the manufacturer for any
 commercially available products containing this drug.}
 \item{labeller}{The corporation responsible for labelling this product.}
 \item{ndc-id}{The National Drug Code (NDC) identifier of the drug}
 \item{ndc-product-code}{The National Drug Code (NDC) product code from the
  FDA National Drug Code directory.}
 \item{dpd-id}{Drug Product Database (DPD) identification number (a.k.a. DIN)
  from the Canadian Drug Product Database. Only present for drugs that are
  marketed in Canada}
 \item{ema-product-code}{EMA product code from the European Medicines Agency
 Database. Only present for products that are authorized by central procedure
  for marketing in the European Union.}
 \item{ema-ma-number}{EMA marketing authorization number from the European
 Medicines Agency Database. Only present for products that are authorized by
  central procedure for marketing in the European Union.}
 \item{started-marketing-on}{The starting date for market approval.}
 \item{ended-marketing-on}{The ending date for market approval.}
 \item{dosage-form	}{The pharmaceutical formulation by which the drug is
 introduced into the body.}
 \item{strength}{The amount of active drug ingredient provided in the dosage}
 \item{route}{The path by which the drug or product is taken into the body}
 \item{fda-application-number}{The New Drug Application [NDA] number
 assigned to this drug by the FDA.}
 \item{over-the-counter}{A list of Over The Counter (OTC) forms of the drug.}
 \item{generic}{Whether this product is a generic drug.}
 \item{approved}{Indicates whether this drug has been approved by the
 regulating government.}
 \item{country}{The country where this commercially available drug has been
 approved.}
 \item{source}{Source of this product information. For example, a value of
 DPD indicates this information was retrieved from the Canadian Drug Product
  Database.}
 \item{standing}{One of good, discordant, or deprecated. Distinguishes
 products with up to date ingredient information (good) from products with
 conflicting information (discordant) or products that have been removed from
  an active label (deprecated).}
 \item{standing-updated-on}{The date on which the standing was last updated}
 \item{standing-reason}{Explains the non-good standing of the product.
 One of: ingredient_change, code_duplication, invalid, or removed.}
 \item{jurisdiction-marketing-category	}{The marketing category of this
 product in its jurisdiction}
 \item{branded}{Whether this product has a named brand}
 \item{prescription}{Whether this product is only available with
 a prescription}
 \item{unapproved}{Whether this product is not approved in its jurisdiction}
 \item{vaccine}{Whether this product is a vaccine}
 \item{allergenic}{Whether this product is used in allergenic testing}
 \item{cosmetic}{Whether this product is a cosmetic, such as sunscreen}
 \item{kit}{Whether this product is a kit composed of multiple distinct
 parts}
 \item{solo}{Whether this product has only a single active ingredient}
 \item{available}{Whether this product can be sold in its jurisdiction}
 \item{\emph{drugbank_id}}{drugbank id}
}
}
\description{
A list of commercially available products in Canada and the United States
 that contain the drug.
}
\keyword{internal}
