% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbparser-package.R
\docType{package}
\name{dbparser}
\alias{dbparser-package}
\alias{dbparser}
\title{dbparser: A package for reading and parsing \strong{DrugBank} xml database.}
\description{
The main purpose of the `dbparser` package is to parse
[DrugBank](https://go.drugbank.com/) database which is downloadable in XML format
from [this link](https://go.drugbank.com/releases/latest).
}
\details{
The parsed data can then be explored and analyzed.


To achieve this purpose, `dbparser`` package provides three main categories
 of functions:

- xml db reader,

- \strong{DrugBank} elements parsers,

For more information kindly check the
reference/index (https://docs.ropensci.org/dbparser/reference/index.html)
}
\section{xml db reader functions}{

 Reads \strong{DrugBank} xml database and build drug elements full tree in
 memory
}

\section{parsers functions}{

 Each parser function is responsible of parsing certain drug element and
 returning its tibble.

 Check this tutorial
 (https://docs.ropensci.org/dbparser/articles/dbparser.html)
}

\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/dbparser/}
  \item \url{https://github.com/ropensci/dbparser}
  \item Report bugs at \url{https://github.com/ropensci/dbparser/issues}
}

}
\author{
\strong{Maintainer}: Mohammed Ali \email{moh_fcis@yahoo.com}

Authors:
\itemize{
  \item Ali Ezzat \email{ali_ezzat85@yahoo.com}
}

Other contributors:
\itemize{
  \item Hao Zhu \email{haozhu233@gmail.com} [reviewer]
  \item Emma Mendelsohn [reviewer]
}

}
\keyword{internal}
