% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_add_cause_label_df.R
\name{prep_add_cause_label_df}
\alias{prep_add_cause_label_df}
\title{Convert missing codes in metadata format v1.0 and a missing-cause-table
to v2.0 missing list / jump list assignments}
\usage{
prep_add_cause_label_df(
  item_level = "item_level",
  cause_label_df,
  label_col = VAR_NAMES,
  assume_consistent_codes = TRUE,
  replace_meta_data = ("resp_vars" \%in\% colnames(cause_label_df)),
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{cause_label_df}{\link{data.frame} missing code table. If missing codes have
labels the respective data frame can be
specified here, see \link{cause_label_df}}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{assume_consistent_codes}{\link{logical} if TRUE and no labels are given and
the same missing/jump code is used
for more than one variable, the
labels assigned for this code will
be the same for all variables.}

\item{replace_meta_data}{\link{logical} if \code{TRUE}, ignore existing missing codes
and jump codes and replace them with
data from the \code{cause_label_df}. Otherwise,
copy the labels from \code{cause_label_df} to
the existing code columns.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
\link{data.frame} updated metadata including all the code labels in
missing/jump lists
}
\description{
The function has to working modes. If \code{replace_meta_data} is \code{TRUE}, by
default, if \code{cause_label_df} contains a column
named \code{resp_vars}, then the missing/jump codes in
\code{meta_data[, c(MISSING_CODES, JUMP_CODES)]} will be overwritten, otherwise,
it will be labeled using the \code{cause_label_df}.
}
\details{
If a column \code{resp_vars} exists, then rows with a value in \code{resp_vars} will
only be used for the corresponding variable.
}
\seealso{
\link{prep_extract_cause_label_df}
}
